#pragma once
#ifndef VIEW_H_
#define VIEW_H_

#include <wx/glcanvas.h>
#include <wx/window.h>

#include <XFaceApp/ModelCamera.h>
#include "Face.h"

class Frame;

class View : public wxGLCanvas
{
	DECLARE_EVENT_TABLE()
private:
	const Frame* _frame;
	XFaceApp::ModelCamera* _camera;
	XFaceApp::Face* _face;
	std::string _initialFAP, _initialFDPFileName, _initialFDPPath;
	bool _init;

protected:
	void OnSize(wxSizeEvent& event);
	void OnPaint(wxPaintEvent& event);
	void OnEraseBackground(wxEraseEvent& event){};
	void OnIdle(wxIdleEvent& event);
	void Render();
	void InitGL();
	void LoadFace();

public:
	void SetBackgroundColour(wxColour col);
	void StartPlayback();
	void StopPlayback();
	void LoadFDP(const std::string& filename, const std::string& path);
	void LoadFAP(const std::string& filename);

	void SetInitialFap(const std::string& filename) {_initialFAP = filename;}
	void SetInitialFdp(const std::string& filename, const std::string path) {_initialFDPFileName = filename; _initialFDPPath = path;}

	View(wxWindow *parent, const Frame* frame, const wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = 0, const wxString& name = _T("FaceView"));
	~View(void);
};

#endif //VIEW_H_